/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.rssnews;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import djbuch.kapitel_06.DemoTools;

import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.Session;

/** Diese Klasse ldt einen RSS Newsticker 
 * und wandelt ihn anhand eines XSL Stylesheets in HTML um.
 * 
 * Diese Klasse ist geeignet fr die Ausfhrung unter Domino R7.x
 * und bentigt mindestens eine JRE 1.4.1
 *
 * @author Thomas Ekert
 *
 */
public class RSSNewsR7 {
	
	private Session session = null;
	private Database db = null;
	private Document doc = null;
	private String code = null;
	private static final String ITEM_BODY = "Body";
	
	public RSSNewsR7(AgentContext ac) throws NotesException {
		db = ac.getCurrentDatabase();
		doc = ac.getDocumentContext();
		session = db.getParent();
	}

	public void process () throws IOException {
		String NL = "\n";
		code = easyUrlReader("http://www.heise.de/newsticker/heise.rdf");
		String replace1 = "<rdf:RDF" + NL
				+ "xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\""
				+ NL + "xmlns=\"http://my.netscape.com/rdf/simple/0.9/\">";
		String replace2 = "</rdf:RDF>";
		code = replaceSubstring(code, replace1, "<query>");
		code = replaceSubstring(code, replace2, "</query>");
		code = processCodeSS(code,xsl);
		code = BEGIN + replaceSubstring(code, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "") + END;
	}

	public String getCode() {
		return code;
	}
	
	public void attach (String output) throws NotesException {
		RichTextItem item = null;
		if (doc.hasItem(ITEM_BODY)) {
			doc.removeItem(ITEM_BODY);
		}
		item = doc.createRichTextItem(ITEM_BODY);
		BufferedReader br = new BufferedReader (new StringReader (output));
		try {
			String line = br.readLine();
			while (line != null) {
				item.appendText(line);
				item.addNewLine();
				line=br.readLine();
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static String processCodeSS(String code, String xsl) {
		StringWriter stringwriter = new StringWriter();
		try {

			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();

			DocumentBuilder builder = factory.newDocumentBuilder();
			File f = tempfile (code, ".xml");
			org.w3c.dom.Document document = builder.parse(f);

			TransformerFactory tFactory = TransformerFactory.newInstance();
			File fxsl = tempfile (xsl, ".xsl");
			StreamSource streamsource = new StreamSource (fxsl);
			Transformer transformer = tFactory.newTransformer(streamsource);

			DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stringwriter);
            transformer.transform(source, result);
			f.delete();
			fxsl.delete();
		} catch (Exception exception) {
			exception.printStackTrace();
		}
		return stringwriter.toString();
	}
	
	private static File tempfile (String s, String ext) throws IOException {
		String name = DemoTools.getRandomString(10) + ext;
		FileWriter fw = new FileWriter(name);
		fw.write(s);
		fw.flush();
		fw.close();
		return new File (name);
	}
	
	private static String easyUrlReader(String urlString) throws IOException {
		URL url = new URL(urlString);
		HttpURLConnection conn = (HttpURLConnection) url.openConnection();
		StringBuffer result = new StringBuffer();
		BufferedReader urlInput = new BufferedReader(new InputStreamReader(conn
				.getInputStream()));
		String line = "";
		while ((line = urlInput.readLine()) != null) {
			result.append(line + "\n");
		}
		urlInput.close();
		return result.toString();
	}

	private static void saveStringToFile(String s, String s1) {
		try {
			FileWriter filewriter = new FileWriter(s1);
			filewriter.write(s);
			filewriter.flush();
			filewriter.close();
			filewriter = null;
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static String loadStringFromFile(String s, int i) {
		int j = 32768;
		j = i <= 0 || i >= j ? j : i;
		FileReader filereader = null;
		try {
			String s1 = "";
			try {
				filereader = new FileReader(s);
				StringWriter stringwriter = new StringWriter();
				char ac[] = new char[j];
				int k = 0;
				int l = 0;
				while ((k = filereader.read(ac, 0, ac.length)) > 0) {
					stringwriter.write(ac, 0, k);
					l += k;
					if (i > 0 && l >= i)
						break;
				}
				s1 = stringwriter.toString();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
				return "";
			} catch (IOException e) {
				e.printStackTrace();
				return "";
			}
			return s1;
		} finally {
			try {
				if (filereader != null)
					filereader.close();
			} catch (IOException ioexception1) {
			}
		}
	}

	/**
	 * String Replacement Funktion fr JVM <= 1.3.x
	 * @param source
	 * @param from
	 * @param to
	 * @return
	 */
	private static String replaceSubstring(String source, String from, String to) {
		if (source == null)
			return null;
		StringBuffer result = new StringBuffer();
		int i = 0;
		for (int j = 0; (j = source.indexOf(from, i)) >= 0;) {
			result.append(source.substring(i, j));
			result.append(to);
			i = j + from.length();
		}

		result.append(source.substring(i));
		return result.toString();
	}
	private static final String BEGIN = "<html>\n<head>\n<title>DEMO RSS - Ticker</title>\n</head>\n<body>\n";
	private static final String END = "\n</body>\n</html>";
	private static final String xsl =
		   "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
		 + "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">"
		 + "<xsl:template match=\"/\">"
		 + "<xsl:for-each select=\"query\">"
		 + "<xsl:for-each select=\"item\">"
		 + "<xsl:if test=\"position()=1\">"
		 + "<table border=\"0\">"
		 + "<tbody>"
		 + "<xsl:for-each select=\"../item\">"
		 + "<tr height=\"8px\">"
		 + "<td width=\"471\">"
		 + "<xsl:for-each select=\"title\">"
		 + "<a text-decoration=\"underline\" color=\"blue\">"
		 + "<xsl:attribute name=\"href\"><xsl:value-of select=\"../link\" /></xsl:attribute>"
		 + "<span style=\"font-family:Verdana; font-size:10px; font-style:normal; text-decoration:none\">"
		 + "<xsl:apply-templates/>"
		 + "</span>"
		 + "</a>"
		 + "</xsl:for-each>"
		 + "</td>"
		 + "</tr>"
		 + "</xsl:for-each>"
		 + "</tbody>"
		 + "</table>"
		 + "</xsl:if>"
		 + "</xsl:for-each>"
		 + "</xsl:for-each>"
		 + ""
		 + "</xsl:template>"
		 + "<xsl:template match=\"item\">"
		 + "<xsl:apply-templates/>"
		 + "</xsl:template>"
		 + "</xsl:stylesheet>";
}